﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace KeyConfig
{
	internal class PadMonitor
	{
		internal PadMonitor(JoyPad pad)
		{
			this.pad = pad;
		}

		internal event EventHandler<DataEventArgs<int>> Pressed;

		protected virtual void OnPressed(DataEventArgs<int> e)
		{
			if (Pressed != null)
			{
				Pressed(this, e);
			}
		}

		JoyPad pad;
		int? last = null;

		internal void Check()
		{
			var list = pad.GetPressed();

			if (list.Count == 1)
			{
				var value = list[0];

				if (last != value)
				{
					OnPressed(new DataEventArgs<int>(value));
					last = value;
				}
			}
			else if (list.Count == 0)
			{
				last = null;
			}
		}
	}
}